#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;
using NinjaTrader.NinjaScript.Indicators;
using NinjaTrader.NinjaScript.DrawingTools;
#endregion

namespace NinjaTrader.NinjaScript.Strategies
{
    public class TurnNBurn : Strategy
    {
        private NinjaTrader.NinjaScript.Indicators.LivewireTradingSuite.LivewireWaddahExplosion LivewireWaddahExplosion1;
        private int BanBar;
        private string atmStrategyId = string.Empty;
        private string orderId = string.Empty;
        private bool isAtmStrategyCreated = false;
        private int Fire_Buy_Order;
        private int Fire_Sell_Order;        
        private int Arm_Long;
        private int Arm_Short;
        private int orderPlacedBar;
        private double dailyRealizedPnL;       
        private double reversalStopPrice;        
        private DateTime positionOpenedTime; 
        private bool isPositionActive;
        private bool longButtonClicked;
        private bool shortButtonClicked;
        private System.Windows.Controls.Button longButton;
        private System.Windows.Controls.Button shortButton;
        private System.Windows.Controls.Grid myGrid;

        protected override void OnStateChange()
        {
            if (State == State.SetDefaults)
            {
                Description                                 = @"Version 1.03";
                Name                                        = "TurnNBurn";
                Calculate                                   = Calculate.OnEachTick; 
                EntriesPerDirection                         = 1;
                EntryHandling                               = EntryHandling.AllEntries;
                IsExitOnSessionCloseStrategy                = true;
                ExitOnSessionCloseSeconds                   = 30;
                IsFillLimitOnTouch                          = false;
                MaximumBarsLookBack                         = MaximumBarsLookBack.TwoHundredFiftySix;
                OrderFillResolution                         = OrderFillResolution.Standard;
                Slippage                                    = 0;
                StartBehavior                               = StartBehavior.WaitUntilFlat;
                TimeInForce                                 = TimeInForce.Gtc;
                TraceOrders                                 = false;
                RealtimeErrorHandling                       = RealtimeErrorHandling.StopCancelClose;
                StopTargetHandling                          = StopTargetHandling.PerEntryExecution;
                BarsRequiredToTrade                         = 5;
                IsInstantiatedOnEachOptimizationIteration   = true;
                
                Atm_Strategy        = "AtmStrategyTemplate";
                CancelWaitBars      = 2;
                EntryOffsetTicks    = 2;
                
                MaxDailyLoss        = 500; 
                DailyProfitTarget   = 500;
                
                StartTime1          = DateTime.Parse("00:00"); 
                EndTime1            = DateTime.Parse("00:00");
                StartTime2          = DateTime.Parse("00:00");
                EndTime2            = DateTime.Parse("00:00");

                UseWaddahConfluence = false;

                BanBar                  = 1;
                Fire_Buy_Order          = 0;
                Fire_Sell_Order         = 0;
                Arm_Long                = 0;
                Arm_Short               = 0;
                orderPlacedBar          = 0;
                dailyRealizedPnL        = 0;
                reversalStopPrice       = 0;
                
                isPositionActive        = false;
            }
            else if (State == State.Configure)
            {
                AddDataSeries(Data.BarsPeriodType.Tick, 1);
            }
            else if (State == State.Historical)
            {
                if (UserControlCollection.Contains(myGrid))
                    return;
                
                Dispatcher.InvokeAsync((() =>
                {
                    myGrid = new System.Windows.Controls.Grid
                    {
                        Name = "MyCustomGrid", HorizontalAlignment = HorizontalAlignment.Right, VerticalAlignment = VerticalAlignment.Top
                    };
                    
                    System.Windows.Controls.ColumnDefinition column1 = new System.Windows.Controls.ColumnDefinition();
                    System.Windows.Controls.ColumnDefinition column2 = new System.Windows.Controls.ColumnDefinition();
                    
                    myGrid.ColumnDefinitions.Add(column1);
                    myGrid.ColumnDefinitions.Add(column2);
                    
                    longButton = new System.Windows.Controls.Button
                    {
                        Name = "LongButton", Content = "LONG", Foreground = Brushes.White, Background = Brushes.Crimson, FontWeight = FontWeights.Bold, FontSize = 12
                    };
                    
                    shortButton = new System.Windows.Controls.Button
                    {
                        Name = "ShortButton", Content = "SHORT", Foreground = Brushes.White, Background = Brushes.Crimson, FontWeight = FontWeights.Bold, FontSize = 12
                    };
                    
                    longButton.Click += OnButtonClick;
                    shortButton.Click += OnButtonClick;
                    
                    System.Windows.Controls.Grid.SetColumn(longButton, 0);
                    System.Windows.Controls.Grid.SetColumn(shortButton, 1);
                    
                    myGrid.Children.Add(longButton);
                    myGrid.Children.Add(shortButton);
                    
                    UserControlCollection.Add(myGrid);
                }));
            }
            else if (State == State.Terminated)
            {
                Dispatcher.InvokeAsync((() =>
                {
                    if (myGrid != null)
                    {
                        if (longButton != null)
                        {
                            myGrid.Children.Remove(longButton);
                            longButton.Click -= OnButtonClick;
                            longButton = null;
                        }
                        if (shortButton != null)
                        {
                            myGrid.Children.Remove(shortButton);
                            shortButton.Click -= OnButtonClick;
                            shortButton = null;
                        }
                    }
                }));
            }
            else if (State == State.DataLoaded)
            {               
                LivewireWaddahExplosion1 = LivewireWaddahExplosion(Close, false, false, 150, false, CustomTimeFrame.Tick, 1000, 160, 20, 40, 20, 2, false, 80, false, false, 14, 20, 10);          
            }
        }
            
        protected override void OnBarUpdate()
        {                       
            if (BarsInProgress != 0) 
                return;
            
            if (CurrentBars[0] < 5)
                return;

            if (Bars.IsFirstBarOfSession)
            {
                dailyRealizedPnL = 0;
            }

            // =========================================================================
            // 1. MANAGE ORDER STATUS & PNL
            // =========================================================================
            if (orderId.Length > 0)
            {
                string[] status = GetAtmStrategyEntryOrderStatus(orderId);
                
                if (status.GetLength(0) > 0)
                {
                    if (status[2] == "Filled" || status[2] == "Cancelled" || status[2] == "Rejected")
                    {
                        orderId = string.Empty;
                    }
                    else if (status[2] == "Working" || status[2] == "Accepted" || status[2] == "Pending")
                    {
                        int barsPassed = CurrentBars[0] - orderPlacedBar;
                        if (barsPassed >= CancelWaitBars)
                        {
                            AtmStrategyCancelEntryOrder(orderId);
                            orderId = string.Empty;
                            atmStrategyId = string.Empty;
                        }
                    }
                }
            }

            else if (atmStrategyId.Length > 0 && GetAtmStrategyMarketPosition(atmStrategyId) == Cbi.MarketPosition.Flat)
            {
                double lastTradePnL = GetAtmStrategyRealizedProfitLoss(atmStrategyId);
                dailyRealizedPnL += lastTradePnL;
                
                atmStrategyId = string.Empty;
                reversalStopPrice = 0;
                isPositionActive = false; 
            }
            
            // =========================================================================
            // 2. DYNAMIC STOP LOOP (Moves Stop1 through Stop20)
            // =========================================================================
            if (atmStrategyId.Length > 0 
                && GetAtmStrategyMarketPosition(atmStrategyId) != MarketPosition.Flat 
                && reversalStopPrice != 0)
            {
                if (!isPositionActive)
                {
                    positionOpenedTime = DateTime.Now;
                    isPositionActive = true;
                    Print(Time[0] + " Position Detected. Initializing Stop Move Routine...");
                }

                double secondsSinceOpen = (DateTime.Now - positionOpenedTime).TotalSeconds;


                if (secondsSinceOpen > 1.0 && secondsSinceOpen < 4.0)
                {                 
                    for (int i = 1; i <= 20; i++)
                    {
                         AtmStrategyChangeStopTarget(0, reversalStopPrice, "Stop" + i, atmStrategyId);
                    }
                }
                else if (secondsSinceOpen >= 4.0 && secondsSinceOpen < 4.1) 
                {
                     Print(Time[0] + " Stop Move Routine Complete (Checked Stops 1-20).");
                }
            }

            // =========================================================================
            // 3. RISK MANAGEMENT
            // =========================================================================
            double currentUnrealized = 0;
            if (atmStrategyId.Length > 0)
            {
                currentUnrealized = GetAtmStrategyUnrealizedProfitLoss(atmStrategyId);
            }

            double totalDailyPnL = dailyRealizedPnL + currentUnrealized;

            if (MaxDailyLoss > 0 && totalDailyPnL <= -MaxDailyLoss)
            {
                if (atmStrategyId.Length > 0) AtmStrategyClose(atmStrategyId);
                if (orderId.Length > 0) AtmStrategyCancelEntryOrder(orderId);
                DisarmButtons();
                return;
            }

            if (DailyProfitTarget > 0 && totalDailyPnL >= DailyProfitTarget)
            {
                if (atmStrategyId.Length > 0) AtmStrategyClose(atmStrategyId);
                if (orderId.Length > 0) AtmStrategyCancelEntryOrder(orderId);
                DisarmButtons();
                return;
            }

            // =========================================================================
            // 4. ENTRY LOGIC (ON BAR CLOSE)
            // =========================================================================
            if (IsFirstTickOfBar)
            {
                bool isTimeValid = false;
                TimeSpan now = Time[0].TimeOfDay;
                
                if (StartTime1.TimeOfDay != EndTime1.TimeOfDay)
                {
                    if (now >= StartTime1.TimeOfDay && now <= EndTime1.TimeOfDay)
                        isTimeValid = true;
                }
                
                if (!isTimeValid && StartTime2.TimeOfDay != EndTime2.TimeOfDay)
                {
                    if (now >= StartTime2.TimeOfDay && now <= EndTime2.TimeOfDay)
                        isTimeValid = true;
                }

                if (StartTime1.TimeOfDay == EndTime1.TimeOfDay && StartTime2.TimeOfDay == EndTime2.TimeOfDay)
                {
                    isTimeValid = true;
                }

                if (!isTimeValid)
                    return;

                bool longConfluence = true;
                bool shortConfluence = true;

                if (UseWaddahConfluence)
                {
                    longConfluence  = (LivewireWaddahExplosion1.TradeSignalPlot[1] == 1);
                    shortConfluence = (LivewireWaddahExplosion1.TradeSignalPlot[1] == -1);
                }

                if (
                     ((LivewireWaddahExplosion1.TrendUp[1] > LivewireWaddahExplosion1.DeadZoneLine[1] || (LivewireWaddahExplosion1.TrendDown[1] > LivewireWaddahExplosion1.DeadZoneLine[1]))
                     && (Close[1] > Open[1] && Close[2] < Open[2] && Close[3] < Open[3])
                     && (Arm_Long == 1)
                     && (CurrentBars[0] != BanBar)
                     && longConfluence))
                {
                    Fire_Buy_Order = 1;
                }
                
                if (
                     ((LivewireWaddahExplosion1.TrendUp[1] > LivewireWaddahExplosion1.DeadZoneLine[1] || (LivewireWaddahExplosion1.TrendDown[1] > LivewireWaddahExplosion1.DeadZoneLine[1]))
                     && (Close[1] < Open[1] && Close[2] > Open[2] && Close[3] > Open[3])
                     && (Arm_Short == 1)
                     && (CurrentBars[0] != BanBar)
                     && shortConfluence))
                {
                    Fire_Sell_Order = 1; 
                }
                
                if ((Fire_Buy_Order == 1)
                    && !(GetAtmStrategyMarketPosition(atmStrategyId) == MarketPosition.Flat))
                {
                    Fire_Buy_Order = 0;
                }
                
                if ((Fire_Sell_Order == 1)
                    && !(GetAtmStrategyMarketPosition(atmStrategyId) == MarketPosition.Flat))
                {
                    Fire_Sell_Order = 0;
                }   

                // --- EXECUTE BUY ---
                if ((Fire_Buy_Order == 1)
                    && (GetAtmStrategyMarketPosition(atmStrategyId) == MarketPosition.Flat)
                    && (orderId.Length == 0 && atmStrategyId.Length == 0))
                {
                    BanBar = Convert.ToInt32(CurrentBars[0]);
                    Fire_Buy_Order = 0;
                    isAtmStrategyCreated = false;
                    atmStrategyId = GetAtmStrategyUniqueId();
                    orderId = GetAtmStrategyUniqueId();
                    orderPlacedBar = CurrentBars[0];
                    
                    double calculatedEntryPrice = High[1] + (EntryOffsetTicks * TickSize);
                    reversalStopPrice = Low[1] - (2 * TickSize); 
                    
                    Print(Time[0] + " LONG Signal. Stop Price set to: " + reversalStopPrice);

                    OrderType type = OrderType.StopMarket;
                    double limitPrice = 0;
                    double stopPrice = calculatedEntryPrice;

                    if (calculatedEntryPrice < Close[0]) 
                    {
                        type = OrderType.Limit;
                        limitPrice = calculatedEntryPrice;
                        stopPrice = 0; 
                    }

                    AtmStrategyCreate(OrderAction.Buy, type, limitPrice, stopPrice, TimeInForce.Day, orderId, Atm_Strategy, atmStrategyId, (atmCallbackErrorCode, atmCallBackId) => {
                        if (atmCallbackErrorCode == ErrorCode.NoError && atmCallBackId == atmStrategyId)
                            isAtmStrategyCreated = true;
                    });
                }
                
                // --- EXECUTE SELL ---
                if ((Fire_Sell_Order == 1)
                    && (GetAtmStrategyMarketPosition(atmStrategyId) == MarketPosition.Flat)
                    && (orderId.Length == 0 && atmStrategyId.Length == 0))
                {
                    BanBar = Convert.ToInt32(CurrentBars[0]);
                    Fire_Sell_Order = 0;
                    isAtmStrategyCreated = false; 
                    atmStrategyId = GetAtmStrategyUniqueId();
                    orderId = GetAtmStrategyUniqueId();
                    orderPlacedBar = CurrentBars[0];
                    
                    double calculatedEntryPrice = Low[1] - (EntryOffsetTicks * TickSize);
                    reversalStopPrice = High[1] + (2 * TickSize); 

                    Print(Time[0] + " SHORT Signal. Stop Price set to: " + reversalStopPrice);

                    OrderType type = OrderType.StopMarket;
                    double limitPrice = 0;
                    double stopPrice = calculatedEntryPrice;

                    if (calculatedEntryPrice > Close[0])
                    {
                        type = OrderType.Limit;
                        limitPrice = calculatedEntryPrice;
                        stopPrice = 0; 
                    }

                    AtmStrategyCreate(OrderAction.Sell, type, limitPrice, stopPrice, TimeInForce.Day, orderId, Atm_Strategy, atmStrategyId, (atmCallbackErrorCode, atmCallBackId) => {
                        if (atmCallbackErrorCode == ErrorCode.NoError && atmCallBackId == atmStrategyId)
                            isAtmStrategyCreated = true;
                    });
                }
            } 
        }

        private void DisarmButtons()
        {
            if (myGrid == null) return;
            
            Dispatcher.InvokeAsync((() =>
            {
                if (longButton != null)
                {
                    longButton.Content = "LONG";
                    longButton.Name = "LongButton";
                    longButtonClicked = false;
                    Arm_Long = 0;
                    longButton.Background = Brushes.Crimson;
                    longButton.Foreground = Brushes.White;
                }
                if (shortButton != null)
                {
                    shortButton.Content = "SHORT";
                    shortButton.Name = "ShortButton";
                    shortButtonClicked = false;
                    Arm_Short = 0;
                    shortButton.Background = Brushes.Crimson;
                    shortButton.Foreground = Brushes.White;
                }
            }));
        }

        private void OnButtonClick(object sender, RoutedEventArgs rea)
        {
            System.Windows.Controls.Button button = sender as System.Windows.Controls.Button;
            if (button == longButton && button.Name == "LongButton" && button.Content == "LONG")
            {
                button.Content = "ARMED";
                button.Name = "ArmLongButton";
                longButtonClicked = true;
                Arm_Long = 1;
                longButton.Background = Brushes.Lime;
                longButton.Foreground = Brushes.Black;
                return;
            }
            
            if (button == shortButton && button.Name == "ShortButton" && button.Content == "SHORT")
            {
                button.Content = "ARMED";
                button.Name = "ArmShortButton";
                shortButtonClicked = true;
                Arm_Short = 1;
                shortButton.Background = Brushes.Lime;
                shortButton.Foreground = Brushes.Black;
                return;
            }
            
            if (button == longButton && button.Name == "ArmLongButton" && button.Content == "ARMED")
            {
                button.Content = "LONG";
                button.Name = "LongButton";
                longButtonClicked = false;
                Arm_Long = 0;
                longButton.Background = Brushes.Crimson;
                longButton.Foreground = Brushes.White;
                
                return;
            }
            
            if (button == shortButton && button.Name == "ArmShortButton" && button.Content == "ARMED")
            {
                button.Content = "SHORT";
                button.Name = "ShortButton";
                shortButtonClicked = false;
                Arm_Short = 0;
                shortButton.Background = Brushes.Crimson;
                shortButton.Foreground = Brushes.White;
                return;
            }
        }

        #region Properties
        [NinjaScriptProperty]
        [Display(Name = "ATM Strategy", Description = "Name of the ATM strategy template to use.", Order=1, GroupName = "Parameters")]
        [TypeConverter(typeof(AtmStrategyConverter))]
        public string Atm_Strategy { get; set; }

        [NinjaScriptProperty]
        [Range(0, int.MaxValue)]
        [Display(Name="Cancel Wait Bars", Description="How many bars to wait before canceling a pending order", Order=2, GroupName="Parameters")]
        public int CancelWaitBars { get; set; }
        
        [NinjaScriptProperty]
        [Range(0, int.MaxValue)]
        [Display(Name="Entry Offset Ticks", Description="Ticks above/below bar to place stop order", Order=3, GroupName="Parameters")]
        public int EntryOffsetTicks { get; set; }
        
        [NinjaScriptProperty]
        [Display(Name="Use Waddah Explosion Confluence", Description="If enabled, requires Explosion + Reversal on same bar", Order=4, GroupName="Parameters")]
        public bool UseWaddahConfluence { get; set; }
        
        [NinjaScriptProperty]
        [Range(0, double.MaxValue)]
        [Display(Name="Max Daily Loss", Description="Stops trading if Daily PnL hits this negative value", Order=5, GroupName="Risk Management")]
        public double MaxDailyLoss { get; set; }

        [NinjaScriptProperty]
        [Range(0, double.MaxValue)]
        [Display(Name="Daily Profit Target", Description="Stops trading if Daily PnL hits this positive value", Order=6, GroupName="Risk Management")]
        public double DailyProfitTarget { get; set; }
        
        [NinjaScriptProperty]
        [PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
        [Display(Name = "Start Time 1", Description = "Start of first trading window. 1200am-1159pm for all day.", Order = 7, GroupName = "Time Windows")]
        public DateTime StartTime1 { get; set; }

        [NinjaScriptProperty]
        [PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
        [Display(Name = "End Time 1", Description = "End of first trading window. 1200am-1159pm for all day. ", Order = 8, GroupName = "Time Windows")]
        public DateTime EndTime1 { get; set; }
        
        [NinjaScriptProperty]
        [PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
        [Display(Name = "Start Time 2", Description = "Start of second trading window. 1200am-1159pm for all day.", Order = 9, GroupName = "Time Windows")]
        public DateTime StartTime2 { get; set; }

        [NinjaScriptProperty]
        [PropertyEditor("NinjaTrader.Gui.Tools.TimeEditorKey")]
        [Display(Name = "End Time 2", Description = "End of second trading window. 1200am-1159pm for all day.", Order = 10, GroupName = "Time Windows")]
        public DateTime EndTime2 { get; set; }
        #endregion
    }

    public class AtmStrategyConverter : TypeConverter
    {
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
        {
            return true;
        }

        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
        {
            return true;
        }

        public override StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
        {
            try 
            {
                string path = System.IO.Path.Combine(NinjaTrader.Core.Globals.UserDataDir, "templates", "AtmStrategy");
                if (!System.IO.Directory.Exists(path))
                    return new StandardValuesCollection(new System.Collections.Generic.List<string>());

                string[] files = System.IO.Directory.GetFiles(path, "*.xml");
                System.Collections.Generic.List<string> strategies = new System.Collections.Generic.List<string>();

                foreach (string file in files)
                {
                    strategies.Add(System.IO.Path.GetFileNameWithoutExtension(file));
                }
                return new StandardValuesCollection(strategies);
            }
            catch
            {
                return new StandardValuesCollection(new System.Collections.Generic.List<string>());
            }
        }
    }
}